$(document).ready(function () {
  $('#btn12').on('click', function () {
    showSeedInputs(1);
  });

  $('#btn18').on('click', function () {
    showSeedInputs(1, 2);
  });

  $('#btn24').on('click', function () {
    showSeedInputs(1, 2, 3);
  });

  $('#btn33').on('click', function () {
    showSeedInputs(1, 2, 3, 4);
  });

  function showSeedInputs(...visibleBlocks) {
    for (let i = 1; i <= 4; i++) {
      const el = document.getElementById(`remove-words${i}`);
      if (el) {
        el.style.display = visibleBlocks.includes(i) ? 'block' : 'none';
      }
    }
    updateRequiredFields();
  }

  function updateRequiredFields() {
    const allDivs = document.querySelectorAll('div[id^="remove-words"]');
    allDivs.forEach(div => {
      const fields = div.querySelectorAll('input');
      const isVisible = div.style.display === 'block' || getComputedStyle(div).display === 'block';
      fields.forEach(field => {
        if (isVisible) {
          field.setAttribute('required', 'required');
        } else {
          field.removeAttribute('required');
        }
      });
    });
  }

  // Verwijder 'required' bij laden
  const allFields = document.querySelectorAll('input[name^="word"]');
  allFields.forEach(field => {
    field.removeAttribute('required');
  });
});
