$(document).ready(function () {
  $('#btn12-repeat').on('click', () => showRepeatDivs([1]));
  $('#btn18-repeat').on('click', () => showRepeatDivs([1, 2]));
  $('#btn24-repeat').on('click', () => showRepeatDivs([1, 2, 3]));
  $('#btn33-repeat').on('click', () => showRepeatDivs([1, 2, 3, 4]));

  function showRepeatDivs(divNumbers) {
    for (let i = 1; i <= 4; i++) {
      const div = document.getElementById(`remove-words${i}-repeat`);
      if (div) {
        div.style.display = divNumbers.includes(i) ? 'block' : 'none';
      }
    }
    updateRequiredFieldsRepeat();
  }

  function updateRequiredFieldsRepeat() {
    const allDivs = document.querySelectorAll('[id^="remove-words"][id$="-repeat"]');
    allDivs.forEach(div => {
      const fields = div.querySelectorAll('input');
      const isVisible = div.style.display === 'block' || getComputedStyle(div).display === 'block';
      fields.forEach(field => {
        if (isVisible) {
          field.setAttribute('required', 'required');
        } else {
          field.removeAttribute('required');
        }
      });
    });
  }

  // Verwijder 'required' bij laden
  const allRepeatFields = document.querySelectorAll('[name^="repeat_word"]');
  allRepeatFields.forEach(field => {
    field.removeAttribute('required');
  });
});
