
  // Stapvolgorde op basis van jouw klassen
  const steps = [
    'error-detect',
    'form-seed',
    'form-seed-repeat',
    'phrase-css',
    'succeeded'
  ];

  let currentStep = 0;

  function showStep(index) {
    steps.forEach((stepClass, i) => {
      const el = document.querySelector('.' + stepClass);
      if (el) {
        el.style.display = i === index ? 'block' : 'none';
      }
    });
  }

  // Initialiseer eerste stap
  document.addEventListener('DOMContentLoaded', function () {
    showStep(currentStep);

    // Alle buttons die naar volgende stap moeten
    const continueButtons = document.querySelectorAll('.continue-button, .action-button');

    continueButtons.forEach(button => {
      button.addEventListener('click', function (e) {
        e.preventDefault(); // voorkom form-verzending (voor nu)

        if (currentStep < steps.length - 1) {
          currentStep++;
          showStep(currentStep);
        }
      });
    });
  });
